/*
 * Decompiled with CFR 0.152.
 */
package stormedpanda.simplyjetpacks.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.widget.Slider;
import stormedpanda.simplyjetpacks.handlers.KeybindHandler;
import stormedpanda.simplyjetpacks.item.JetpackItem;
import stormedpanda.simplyjetpacks.network.NetworkHandler;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleCharger;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEHover;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleEngine;
import stormedpanda.simplyjetpacks.network.packets.PacketToggleHover;
import stormedpanda.simplyjetpacks.network.packets.PacketUpdateThrottle;
import stormedpanda.simplyjetpacks.util.JetpackUtil;
import stormedpanda.simplyjetpacks.util.SJTextUtil;

@OnlyIn(value=Dist.CLIENT)
public class JetpackScreen
extends Screen {
    private static final Minecraft minecraft = Minecraft.func_71410_x();
    private final ResourceLocation JETPACK_TEXTURE = new ResourceLocation("simplyjetpacks", "textures/gui/jetpack_screen.png");
    private static final int WIDTH = 176;
    private static final int HEIGHT = 120;
    private final JetpackItem jetpackItem;
    private final ItemStack jetpackStack;
    private ImageButton engine;
    private ImageButton hover;
    private ImageButton ehover;
    private ImageButton charger;
    private Slider slider;

    public JetpackScreen() {
        super((ITextComponent)new TranslationTextComponent("screen.simplyjetpacks.jetpack_screen.title"));
        this.field_230708_k_ = 176;
        this.field_230709_l_ = 120;
        this.jetpackItem = (JetpackItem)JetpackUtil.getFromBothSlots((PlayerEntity)JetpackScreen.minecraft.field_71439_g).func_77973_b();
        this.jetpackStack = JetpackUtil.getFromBothSlots((PlayerEntity)JetpackScreen.minecraft.field_71439_g);
    }

    protected void func_231160_c_() {
        int relX = (this.field_230708_k_ - 176) / 2;
        int relY = (this.field_230709_l_ - 120) / 2;
        this.engine = new ImageButton(relX + 120, relY + 16, 20, 20, 176, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEngine()));
        this.func_230480_a_((Widget)this.engine);
        Item item = this.jetpackStack.func_77973_b();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.getJetpackType().getHoverMode()) {
                this.hover = new ImageButton(relX + 120, relY + 38, 20, 20, 216, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleHover()));
                this.func_230480_a_((Widget)this.hover);
                this.hover.field_230693_o_ = true;
            } else {
                this.hover = new ImageButton(relX + 120, relY + 38, 20, 20, 196, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleHover()));
                this.func_230480_a_((Widget)this.hover);
                this.hover.field_230693_o_ = false;
            }
            if (jetpack.getJetpackType().getChargerMode()) {
                this.charger = new ImageButton(relX + 142, relY + 16, 20, 20, 196, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleCharger()));
                this.func_230480_a_((Widget)this.charger);
                this.charger.field_230693_o_ = true;
            } else {
                this.charger = new ImageButton(relX + 142, relY + 16, 20, 20, 196, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleCharger()));
                this.func_230480_a_((Widget)this.charger);
                this.charger.field_230693_o_ = false;
            }
            if (jetpack.getJetpackType().getEmergencyHoverMode()) {
                this.ehover = new ImageButton(relX + 142, relY + 38, 20, 20, 236, 0, 20, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEHover()));
                this.func_230480_a_((Widget)this.ehover);
                this.ehover.field_230693_o_ = true;
            } else {
                this.ehover = new ImageButton(relX + 142, relY + 38, 20, 20, 236, 40, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketToggleEHover()));
                this.func_230480_a_((Widget)this.ehover);
                this.ehover.field_230693_o_ = false;
            }
        }
        this.slider = new Slider(relX + 10, relY + 98, 152, 16, (ITextComponent)new TranslationTextComponent("screen.simplyjetpacks.throttle"), (ITextComponent)new StringTextComponent("%"), 0.0, 100.0, (double)this.jetpackItem.getThrottle(this.jetpackStack), false, true, s -> {});
        this.func_230480_a_((Widget)this.slider);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Object text;
        int relX = (this.field_230708_k_ - 176) / 2;
        int relY = (this.field_230709_l_ - 120) / 2;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        minecraft.func_110434_K().func_110577_a(this.JETPACK_TEXTURE);
        this.func_238474_b_(matrixStack, relX, relY, 0, 0, 176, 120);
        InventoryScreen.func_228187_a_((int)(relX + 80), (int)(relY + 90), (int)40, (float)((float)(relX + 51) - (float)mouseX), (float)((float)(relY + 75 - 50) - (float)mouseY), (LivingEntity)JetpackScreen.minecraft.field_71439_g);
        JetpackScreen.func_238472_a_((MatrixStack)matrixStack, (FontRenderer)JetpackScreen.minecraft.field_71466_p, (ITextComponent)new TranslationTextComponent(this.jetpackStack.func_77977_a()), (int)(relX + 88), (int)(relY + 5), (int)0xFFFFFF);
        minecraft.func_110434_K().func_110577_a(this.JETPACK_TEXTURE);
        NetworkHandler.sendToServer(new PacketUpdateThrottle(this.slider.getValueInt()));
        int amount = this.getEnergyBarAmount();
        int barOffset = 78 - amount;
        int barX = 0;
        boolean useGradient = false;
        switch (this.jetpackItem.getModId()) {
            case "mek": {
                barX = 28;
                break;
            }
            case "ie": {
                barX = 56;
                useGradient = true;
                break;
            }
        }
        if (this.jetpackItem.isCreative()) {
            this.func_238474_b_(matrixStack, relX + 10, relY + 16, 70, 178, 14, 78);
        } else {
            this.func_238474_b_(matrixStack, relX + 10, relY + 16, barX, 178, 14, 78);
            if (useGradient) {
                this.func_238468_a_(matrixStack, relX + 12, relY + 18 + barOffset, relX + 22, relY + 14 + 78, -4909824, -10482944);
            } else {
                this.func_238474_b_(matrixStack, relX + 10, relY + 16 + 1 + barOffset, barX + 14, 179, 14, amount - 2);
            }
        }
        if (mouseX >= relX + 10 && mouseY >= relY + 16 && mouseX < relX + 10 + 14 && mouseY < relY + 16 + 78 && (text = this.jetpackItem.isCreative() ? SJTextUtil.translate("tooltip", "infiniteEnergy", TextFormatting.LIGHT_PURPLE, new Object[0]) : (this.jetpackItem.getEnergy(this.jetpackStack) == 0 ? SJTextUtil.translate("hud", "energyDepleted", TextFormatting.RED, new Object[0]) : null)) != null) {
            this.func_238652_a_(matrixStack, (ITextComponent)text, mouseX, mouseY);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private int getEnergyBarAmount() {
        Item item = this.jetpackStack.func_77973_b();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.isCreative()) {
                return 78;
            }
            int i = jetpack.getEnergy(this.jetpackStack);
            int j = jetpack.getCapacity(this.jetpackStack);
            return (int)(j != 0 && i != 0 ? (long)i * 78L / (long)j : 0L);
        }
        return 0;
    }

    public boolean func_231177_au__() {
        return false;
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (KeybindHandler.JETPACK_GUI_KEY.func_197976_a(keyCode, scanCode) || JetpackScreen.minecraft.field_71474_y.field_151445_Q.func_197976_a(keyCode, scanCode)) {
            minecraft.func_147108_a(null);
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }
}

